local STATES = {
	START = 1,
	PRE_LANG = 2,
	LANG = 3,
	POST_LANG = 4,
	PRE_ARTIFACT = 5,
	ARTIFACT = 6,
	POST_ARTIFACT = 7
}

local BOX_FRAMES = {
	NORMAL = 1,
	SELECTED = 2
}

local SELECTION_DELAY = 200

local function confirmButtons()
	return GetInput"Jump" or GetInput"Attack" or KeyPressed"Enter"
end

local function artifactAlreadyOwned(listOfItems, theNewItem)
	for _,previousItem in pairs(listOfItems) do
		if theNewItem == previousItem then
			return true
		end
	end
	return false
end

local function getRandomArtifact(self, previousResult)
	local listOfItems = self.detector.ListOfAlreadyChosen
	local theNewItem, itemExists;
	repeat
		theNewItem = math.random(self.detector.ArtifactsCount)
		itemExists = artifactAlreadyOwned(listOfItems, theNewItem) or theNewItem == previousResult
	until not itemExists
	return theNewItem
end

local function clawIsOnGround()
	local pt = GetClaw().PhysicsType
	return pt == PhysicsTypes.Stand or pt == PhysicsTypes.Walk
end

function main(self)
	local claw = GetClaw()

    if self.State == 0 then
		self.ItemSelectNo = 1
		self.LanguageSelectNo = 0
		self.DrawFlags.NoDraw = false
		self.EnterPressBuffer = false
		self.detector = GetObject(3206)
		self.backgroundZ = 11000
		self:SetImage"CUSTOM_FLASH"
		SetImgFlag(self.Image, ImageFlag.Ghost)
		SetImgClt(self.Image, "Light")
		self:SetAnimation"GAME_CYCLE100"
		self.State = STATES.START
		return
	end

	self:AnimationStep()

	if self.State == STATES.START and claw:InMinMax(self) and clawIsOnGround() then

		local width, height = self.detector.ScreenW, self.detector.ScreenH
		self.centerX, self.centerY = math.ceil(width/2), math.ceil(height/2)
		self.box1X = self.centerX - 64
		self.box2X = self.centerX + 64
		self.boxY = self.centerY - 160
		self.paperX = self.centerX
		self.paperY = self.centerY + 16
		self.noteX = self.centerX
		self.noteY = self.centerY + 180

		self.background = CreateHUDObject{
			X = self.centerX,
			Y = self.centerY,
			Z = self.backgroundZ,
			logic = "DoNothingNormal",
			image = "CUSTOM_SELECT_SCREEN"
		}

		self.box1 = CreateHUDObject{
			X = self.box1X,
			Y = self.paperY,
			Z = self.backgroundZ + 1,
			logic="DoNothing",
			image="CUSTOM_SELECT_BOX"
		}

		self.box2 = CreateHUDObject{
			X = self.box2X,
			Y = self.paperY,
			Z = self.backgroundZ + 1,
			logic="DoNothing",
			image="CUSTOM_SELECT_BOX"
		}

		PlaySound("GAME_PURELEASE1")
		claw.State = ClawStates.Freeze
		claw:SetAnimation("CLAW_STAND", 100)
		SetRespawnPoint(claw.X, claw.Y)

		-- skip the language selection if the language was chosen before:
		self.State = self.detector.Language and STATES.PRE_ARTIFACT or STATES.PRE_LANG
	end

	if self.State > STATES.START and self.State < STATES.POST_ARTIFACT and claw.Health > 0 then
		claw.State = ClawStates.Freeze
	end

	if self.State == STATES.PRE_LANG then
		self.langFlag1 = CreateHUDObject{
			X = self.box1X,
			Y = self.paperY,
			Z = self.backgroundZ + 2,
			logic="DoNothing",
			image="CUSTOM_SELECT_FLAGS_ENG"
		}

		self.langFlag2 = CreateHUDObject{
			X = self.box2X,
			Y = self.paperY,
			Z = self.backgroundZ + 2,
			logic="DoNothing",
			image="CUSTOM_SELECT_FLAGS_PL"
		}

		self.box1.Y = self.paperY
		self.box2.Y = self.paperY
		self.box1:SetImage"CUSTOM_SELECT_BOXF"
		self.box2:SetImage"CUSTOM_SELECT_BOXF"

		self.box1:SetFrame(BOX_FRAMES.SELECTED)
		self.box2:SetFrame(BOX_FRAMES.NORMAL)
		self.selected = 1
		self.confirmationBuffer = false
		self.selectDelay = GetTime() + SELECTION_DELAY

		self.State = STATES.LANG
	end

	if self.State == STATES.LANG then
		if not self.confirmationBuffer and not confirmButtons() then
			self.confirmationBuffer = true
		end

		if (GetInput"Left" or GetInput"Right") and GetTime() > self.selectDelay then
			if self.selected == 1 then
				self.box1:SetFrame(BOX_FRAMES.NORMAL)
				self.box2:SetFrame(BOX_FRAMES.SELECTED)
				self.selected = 2
			else
				self.box1:SetFrame(BOX_FRAMES.SELECTED)
				self.box2:SetFrame(BOX_FRAMES.NORMAL)
				self.selected = 1
			end
			PlaySound("GAME_CLICK")
			self.selectDelay = GetTime() + SELECTION_DELAY
		end

		-- Confirm choice:
		if confirmButtons() and self.confirmationBuffer then
			PlaySound("GAME_SELECT")
			self.State = STATES.POST_LANG
		end
	end

	if self.State == STATES.POST_LANG then
		self.detector.Language = self.selected == 2 and "PL" or "ENG"

		self.langFlag1:Destroy()
		self.langFlag2:Destroy()

		self.State = STATES.PRE_ARTIFACT
	end

	if self.State == STATES.PRE_ARTIFACT then
		self.specialNote = CreateHUDObject{
			X = self.noteX,
			Y = self.noteY,
			Z = self.backgroundZ + 1,
			logic = "DoNothing",
			image="CUSTOM_SELECT_SPECIAL_" .. self.detector.Language
		}

		self.paper = CreateHUDObject{
			X = self.paperX,
			Y = self.paperY,
			Z = self.backgroundZ + 1,
			logic = "DoNothing",
			image="CUSTOM_SELECT_PAPER_" .. self.detector.Language
		}

		self.randomArtifact1 = getRandomArtifact(self, 0)
		self.randomArtifact2 = getRandomArtifact(self, self.randomArtifact1)

		self.artifact1 = CreateHUDObject{
			X = self.box1X,
			Y = self.boxY,
			Z = self.backgroundZ + 2,
			logic = "AniCycle",
			image = self.detector.Artifacts[self.randomArtifact1].Image
		}

		self.artifact2 = CreateHUDObject{
			X = self.box2X,
			Y = self.boxY,
			Z = self.backgroundZ + 2,
			logic = "AniCycle",
			image = self.detector.Artifacts[self.randomArtifact2].Image
		}

		self.paper:SetFrame(self.randomArtifact1)

		self.box1.Y = self.boxY
		self.box2.Y = self.boxY
		self.box1:SetImage"CUSTOM_SELECT_BOX"
		self.box2:SetImage"CUSTOM_SELECT_BOX"
		self.box1:SetFrame(BOX_FRAMES.SELECTED)
		self.box2:SetFrame(BOX_FRAMES.NORMAL)
		self.selected = 1
		self.confirmationBuffer = false
		self.selectDelay = GetTime() + SELECTION_DELAY
		self.selectedArtifact = self.randomArtifact1

		self.specialNote.DrawFlags.NoDraw = self.detector.Artifacts[self.selectedArtifact].Type ~= "Special"

		self.State = STATES.ARTIFACT
	end

	if self.State == STATES.ARTIFACT then
		if not self.confirmationBuffer and not confirmButtons() then
			self.confirmationBuffer = true
		end

		if (GetInput"Left" or GetInput"Right") and GetTime() > self.selectDelay then
			if self.selected == 1 then
				self.box1:SetFrame(BOX_FRAMES.NORMAL)
				self.box2:SetFrame(BOX_FRAMES.SELECTED)
				self.selectedArtifact = self.randomArtifact2
				self.paper:SetFrame(self.selectedArtifact)
				self.selected = 2
			else
				self.box1:SetFrame(BOX_FRAMES.SELECTED)
				self.box2:SetFrame(BOX_FRAMES.NORMAL)
				self.selectedArtifact = self.randomArtifact1
				self.paper:SetFrame(self.selectedArtifact)
				self.selected = 1
			end

			self.specialNote.DrawFlags.NoDraw = self.detector.Artifacts[self.selectedArtifact].Type ~= "Special"

			PlaySound("GAME_CLICK")
			self.selectDelay = GetTime() + SELECTION_DELAY
		end

		if confirmButtons() and self.confirmationBuffer then
			PlaySound("GAME_SELECT")
			self.State = STATES.POST_ARTIFACT
		end
	end

	if self.State == STATES.POST_ARTIFACT then
		self.artifact1:Destroy()
		self.artifact2:Destroy()
		self.paper:Destroy()
		self.specialNote:Destroy()
		self.box1:Destroy()
		self.box2:Destroy()
		self.background:Destroy()
		if claw.State == ClawStates.Freeze then
			claw.State = ClawStates.Stand
		end

		if self.detector.Artifacts[self.selectedArtifact].Type == "Special" then
			for id, art in ipairs(self.detector.Artifacts) do
				if art.Type == "Special" then
					table.insert(self.detector.ListOfAlreadyChosen, id)
				end
			end
		else
			table.insert(self.detector.ListOfAlreadyChosen, self.selectedArtifact)
		end

		CreateObject{
			X = self.SpeedX,
			Y = self.SpeedY,
			Z = 4000,
			name = "ArtifactSpawner",
			Counter = self.selectedArtifact
		}
		self:Destroy()
	end
end
